﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ZSMusic.Model
{
    /// <summary>
    /// 版本信息
    /// </summary>
    [Serializable]
    public class VersionInfo
    {
        public Version UIVersion { get; set; }
        public Version DALVersion { get; set; }
        public string Description { get; set; }
        public bool IsBeta { get; set; }
        public string Title { get; set; }
        public string TitleEx { get; set; }
        public DateTime Time { get; set; }
        public string Url { get; set; }
        public string DALUrl { get; set; }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(Title);
            sb.Append(" ");
            sb.Append(UIVersion);
            sb.Append(" ");
            if (IsBeta)
            {
                sb.Append("Beta ");
            }
            sb.Append(TitleEx);
            return sb.ToString();
        }
    }
}
